/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWPastable;
import filenet.vw.api.IntQueue;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAssociationDefinition;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWIdGenerator;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Logger;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import org.xml.sax.SAXParseException;

public final class VWMapDefinition
extends VWMLABase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7557L;
    String m_className = "VWMapDefinition";
    protected static final Logger logger = Logger.getLogger("filenet.vw.api");
    protected String name = null;
    protected int mapId = -1;
    protected String description = null;
    private VWWorkflowDefinition myWorkflow;
    private VWMapNode[] steps;
    private VWArrayHandler stepsHandler = null;
    protected static final int INVALID_STEP_ID = -1;
    protected static final int FIRST_STEP_ID = 0;
    protected VWIdGenerator stepIdGenerator = new VWIdGenerator(0, 1);
    private VWRouteDefinition[] routes = null;
    private VWArrayHandler routesHandler = new VWArrayHandler();
    private VWTextAnnotationDefinition[] annotations = null;
    private VWArrayHandler annotationsHandler = new VWArrayHandler();
    private VWIdGenerator routeIdGenerator = new VWIdGenerator();
    private VWIdGenerator annotationIdGenerator = new VWIdGenerator();
    protected VWIdGenerator associationIdGenerator = new VWIdGenerator();
    private static final String pasteMapName = "###FN_INTERNAL_SPECIAL_TEMP_PASTE_MAP###";
    private int[] seen = null;
    private int visitOrd = 0;
    private static final int FRINGE = -2;
    private static final int UNSEEN = -1;
    private Vector beenThere = new Vector();

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-08 22:21:26 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/4 $";
    }

    protected void updateNextStepId() throws VWException {
        this.stepIdGenerator.setNextId(this.findHighestStepId() + 1);
    }

    protected int findHighestStepId() throws VWException {
        int currentHighestStepId = 0;
        int numSteps = this.stepsHandler.getElementCount();
        for (int i = 0; i < numSteps; ++i) {
            VWInstructionDefinition[] instArray;
            if (this.steps[i].getStepId() > currentHighestStepId) {
                currentHighestStepId = this.steps[i].getStepId();
            }
            if (!(this.steps[i] instanceof VWCompoundStepDefinition) || (instArray = ((VWCompoundStepDefinition)this.steps[i]).getInstructions()) == null) continue;
            for (int j = 0; j < instArray.length; ++j) {
                if (instArray[j].getInstructionId() <= currentHighestStepId) continue;
                currentHighestStepId = instArray[j].getInstructionId();
            }
        }
        return currentHighestStepId;
    }

    private int getIndexOfStepId(int theStepId) throws VWException {
        int i = this.stepsHandler.getIndexFromIntFieldValue(this.steps, "stepId", theStepId);
        if (i == -1) {
            throw new VWException("vw.api.VWMapDefinitionStepNotFound", "No Step found with stepID {0} in {1} map.", String.valueOf(theStepId), this.getName());
        }
        return i;
    }

    protected VWIdGenerator getStepIdGenerator() {
        return this.stepIdGenerator;
    }

    protected void updateNextAnnotationId() throws VWException {
        this.annotationIdGenerator.setNextId(this.findHighestAnnotationId() + 1);
    }

    protected int findHighestAnnotationId() throws VWException {
        int currentHighestAnnotationId = 0;
        int numAnnotations = this.annotationsHandler.getElementCount();
        for (int i = 0; i < numAnnotations; ++i) {
            if (this.annotations[i].getId() <= currentHighestAnnotationId) continue;
            currentHighestAnnotationId = this.annotations[i].getId();
        }
        return currentHighestAnnotationId;
    }

    protected VWMapDefinition(VWWorkflowDefinition theWorkflow, String theName, boolean createLaunchStep) throws VWException {
        try {
            Class<?> mapNodeClass = Class.forName("filenet.vw.api.VWMapNode");
            this.stepsHandler = new VWArrayHandler(mapNodeClass);
        }
        catch (Exception e) {
            throw new VWException("vw.api.VWMapDefinitionErrorInArrayHandler", "exception initializing the array handler, {0}", e.toString());
        }
        if (theWorkflow == null) {
            throw new VWException("vw.api.VWMapDefinitionInvalidWorkflow", "theWorkflow is invalid, (null).");
        }
        this.myWorkflow = theWorkflow;
        this.setName(theName);
        if (createLaunchStep) {
            VWString locStepName;
            if (this.name.equals("Workflow")) {
                locStepName = new VWString("vw.api.LaunchStepName", "LaunchStep");
                this.createStep(locStepName.toString());
            } else {
                locStepName = new VWString("vw.api.StartStepName", "StartStep");
                this.createStep(locStepName.toString());
            }
        }
    }

    public VWStepDefinition createStep(String theStepName) throws VWException {
        VWStepDefinition newStep = new VWStepDefinition(this, theStepName, this.stepIdGenerator.getNextId());
        this.steps = (VWMapNode[])this.stepsHandler.addElementToArray(this.steps, newStep);
        return newStep;
    }

    protected VWStepDefinition createEmptyStep() throws VWException {
        VWStepDefinition newStep = new VWStepDefinition(this);
        this.steps = (VWMapNode[])this.stepsHandler.addElementToArray(this.steps, newStep);
        return newStep;
    }

    public VWCompoundStepDefinition createCompoundStep(String theStepName) throws VWException {
        VWCompoundStepDefinition newCompStep = new VWCompoundStepDefinition(this, theStepName, this.stepIdGenerator.getNextId());
        this.steps = (VWMapNode[])this.stepsHandler.addElementToArray(this.steps, newCompStep);
        return newCompStep;
    }

    protected VWCompoundStepDefinition createEmptyCompoundStep() throws VWException {
        VWCompoundStepDefinition newCompStep = new VWCompoundStepDefinition(this);
        this.steps = (VWMapNode[])this.stepsHandler.addElementToArray(this.steps, newCompStep);
        return newCompStep;
    }

    protected void prune() throws VWException {
        VWTextAnnotationDefinition[] a;
        VWRouteDefinition[] r = (VWRouteDefinition[])this.routesHandler.getElements(this.routes);
        if (r != null) {
            for (int i = 0; i < r.length; ++i) {
                try {
                    this.getStep(r[i].getDestinationStepId());
                    continue;
                }
                catch (Exception e) {
                    this.getStep(r[i].getSourceStepId()).deleteRoute(r[i].getRouteId());
                }
            }
        }
        if ((a = (VWTextAnnotationDefinition[])this.annotationsHandler.getElements(this.annotations)) != null) {
            for (int i = 0; i < a.length; ++i) {
                VWAssociationDefinition[] assnArr = a[i].getAllAssociations();
                block12: for (int j = 0; j < assnArr.length; ++j) {
                    switch (assnArr[j].getTargetType()) {
                        case 1: {
                            try {
                                this.getStep(assnArr[j].getTargetId());
                            }
                            catch (Exception e) {
                                a[i].deleteAssociation(assnArr[j].getTargetId(), 1);
                            }
                            continue block12;
                        }
                        case 2: {
                            try {
                                this.getRoute(assnArr[j].getTargetId());
                            }
                            catch (Exception e) {
                                a[i].deleteAssociation(assnArr[j].getTargetId(), 2);
                            }
                            continue block12;
                        }
                        default: {
                            throw new VWException("vw.api.VWMapDefinitionBadTextAnnotationTargetType", "Found an association with invalid target type");
                        }
                    }
                }
            }
        }
    }

    public VWMapNode[] pasteSteps(String thePaste) throws VWException {
        try {
            if (this.getWorkflow().getMap(pasteMapName) != null) {
                this.getWorkflow().deleteMap(pasteMapName);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        VWMapNode[] s = null;
        VWRouteDefinition[] r = null;
        VWMapDefinition m = null;
        String stepPastePre = "<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE WorkFlowDefinition SYSTEM \"wfdef4.dtd\">\n<WorkFlowDefinition ApiVersion=\"4.0\"\nOrigin=\"JavaAPI\"\n > <Map\n Name=\"###FN_INTERNAL_SPECIAL_TEMP_PASTE_MAP###\" Description=\"Temporary map created internally during pasteSteps operation\" >";
        String stepPastePost = "</Map>\n</WorkFlowDefinition>\n";
        String theXML = stepPastePre + thePaste + stepPastePost;
        try {
            try {
                VWXMLHandler.parseXMLforPasteSteps(theXML, this.getWorkflow(), true);
            }
            catch (SAXParseException err) {
                VWString parsingError = new VWString("vw.api.ParsingError", "** Parsing error");
                VWString line = new VWString("vw.api.Line", "line");
                String errString = parsingError + ", " + line + " " + err.getLineNumber() + ", uri <" + err.getSystemId() + ">\n" + "   " + err.getMessage();
                throw new VWException("vw.api.VWWorkflowDefinitionXMLReadParse", "XML Parsing error {0}.", errString);
            }
            catch (Exception e) {
                throw new VWException("vw.api.VWWorkflowDefinitionXMLReadError", " Exception reading XML, {0}.", e.getMessage());
            }
            m = this.getWorkflow().getMap(pasteMapName);
            if (m != null) {
                m.prune();
                s = m.getSteps();
                r = (VWRouteDefinition[])m.routesHandler.getElements(m.routes);
                if (s != null) {
                    if (this.stepIdGenerator.getNextId() < m.stepIdGenerator.getNextId()) {
                        this.stepIdGenerator.setNextId(m.stepIdGenerator.getNextId());
                    }
                    for (int i = 0; i < s.length; ++i) {
                        VWInstructionDefinition[] InstArray;
                        int newId = this.stepIdGenerator.getNextId();
                        int oldId = s[i].getStepId();
                        if (r != null) {
                            for (int j = 0; j < r.length; ++j) {
                                if (r[j].getDestinationStepId() == oldId) {
                                    r[j].destinationStepId = newId;
                                }
                                if (r[j].getSourceStepId() != oldId) continue;
                                r[j].sourceStepId = newId;
                            }
                        }
                        s[i].setStepId(newId);
                        s[i].setMap(this);
                        s[i].outGoingRoutesHandler = new VWArrayHandler();
                        s[i].outGoingRoutes = null;
                        if (s[i] instanceof VWCompoundStepDefinition && (InstArray = ((VWCompoundStepDefinition)s[i]).getInstructions()) != null) {
                            for (int j = 0; j < InstArray.length; ++j) {
                                InstArray[j].setInstructionId(this.stepIdGenerator.getNextId());
                            }
                            ((VWCompoundStepDefinition)s[i]).setInstructions(InstArray);
                        }
                        this.steps = (VWMapNode[])this.stepsHandler.addElementToArray(this.steps, s[i]);
                    }
                }
                if (r != null) {
                    for (int j = 0; j < r.length; ++j) {
                        this.getStep(r[j].getSourceStepId()).createRoute(r[j].getDestinationStepId(), r[j].getCondition(), r[j].getName());
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new VWException("vw.api.VWWorkflowDefinitionXMLReadError", " Exception reading XML, {0}.", t.getMessage());
        }
        finally {
            if (m != null) {
                this.getWorkflow().deleteMap(m.getName(), false);
            }
        }
        return s;
    }

    public IVWPastable[] paste(String thePaste) throws VWException {
        try {
            if (this.getWorkflow().getMap(pasteMapName) != null) {
                this.getWorkflow().deleteMap(pasteMapName);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Vector<Cloneable> pasteVect = new Vector<Cloneable>();
        VWMapDefinition m = null;
        VWRouteDefinition[] r = null;
        VWTextAnnotationDefinition[] a = null;
        VWMapNode[] s = null;
        HashMap<Integer, Integer> stepIdMapping = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> routeIdMapping = new HashMap<Integer, Integer>();
        String stepPastePre = "<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE WorkFlowDefinition SYSTEM \"wfdef4.dtd\">\n<WorkFlowDefinition ApiVersion=\"4.0\"\nOrigin=\"JavaAPI\"\n > <Map\n Name=\"###FN_INTERNAL_SPECIAL_TEMP_PASTE_MAP###\" Description=\"Temporary map created internally during paste operation\" >";
        String stepPastePost = "</Map>\n</WorkFlowDefinition>\n";
        String theXML = stepPastePre + thePaste + stepPastePost;
        try {
            try {
                VWXMLHandler.parseXMLforPasteSteps(theXML, this.getWorkflow(), true);
            }
            catch (SAXParseException err) {
                VWString parsingError = new VWString("vw.api.ParsingError", "** Parsing error");
                VWString line = new VWString("vw.api.Line", "line");
                String errString = parsingError + ", " + line + " " + err.getLineNumber() + ", uri <" + err.getSystemId() + ">\n" + "   " + err.getMessage();
                throw new VWException("vw.api.VWWorkflowDefinitionXMLReadParse", "XML Parsing error {0}.", errString);
            }
            catch (Exception e) {
                throw new VWException("vw.api.VWWorkflowDefinitionXMLReadError", " Exception reading XML, {0}.", e.getMessage());
            }
            m = this.getWorkflow().getMap(pasteMapName);
            if (m != null) {
                int i;
                m.prune();
                s = m.getSteps();
                r = (VWRouteDefinition[])m.routesHandler.getElements(m.routes);
                a = m.getTextAnnotations();
                if (s != null) {
                    if (this.stepIdGenerator.getNextId() < m.stepIdGenerator.getNextId()) {
                        this.stepIdGenerator.setNextId(m.stepIdGenerator.getNextId());
                    }
                    for (i = 0; i < s.length; ++i) {
                        VWInstructionDefinition[] InstArray;
                        int newId = this.stepIdGenerator.getNextId();
                        int oldId = s[i].getStepId();
                        stepIdMapping.put(oldId, newId);
                        s[i].setStepId(newId);
                        s[i].setMap(this);
                        s[i].outGoingRoutesHandler = new VWArrayHandler();
                        s[i].outGoingRoutes = null;
                        if (s[i] instanceof VWCompoundStepDefinition && (InstArray = ((VWCompoundStepDefinition)s[i]).getInstructions()) != null) {
                            for (int j = 0; j < InstArray.length; ++j) {
                                InstArray[j].setInstructionId(this.stepIdGenerator.getNextId());
                            }
                            ((VWCompoundStepDefinition)s[i]).setInstructions(InstArray);
                        }
                        this.steps = (VWMapNode[])this.stepsHandler.addElementToArray(this.steps, s[i]);
                        pasteVect.add(s[i]);
                    }
                }
                if (r != null) {
                    for (int j = 0; j < r.length; ++j) {
                        int newSourceStepId = (Integer)stepIdMapping.get(r[j].getSourceStepId());
                        int newDestStepId = (Integer)stepIdMapping.get(r[j].getDestinationStepId());
                        VWRouteDefinition newRoute = this.getStep(newSourceStepId).createRoute(newDestStepId, r[j].getCondition(), r[j].getName());
                        routeIdMapping.put(r[j].getRouteId(), newRoute.getRouteId());
                    }
                }
                if (a != null) {
                    for (i = 0; i < a.length; ++i) {
                        VWTextAnnotationDefinition newAnnotation = this.createTextAnnotation(a[i].getMessage(), a[i].getLocation(), a[i].getDimension(), a[i].isMinimized());
                        newAnnotation.setBgColor(a[i].getBgColor());
                        newAnnotation.setName(a[i].getName());
                        VWAssociationDefinition[] oldAssnsArray = a[i].getAllAssociations();
                        if (oldAssnsArray != null) {
                            for (int j = 0; j < oldAssnsArray.length; ++j) {
                                int newTargetId = -1;
                                int targetType = oldAssnsArray[j].getTargetType();
                                switch (targetType) {
                                    case 1: {
                                        newTargetId = (Integer)stepIdMapping.get(oldAssnsArray[j].getTargetId());
                                        break;
                                    }
                                    case 2: {
                                        newTargetId = (Integer)routeIdMapping.get(oldAssnsArray[j].getTargetId());
                                    }
                                }
                                VWAssociationDefinition newAssociation = newAnnotation.createAssociation(newTargetId, targetType);
                                if (oldAssnsArray[j].getName() == null) continue;
                                newAssociation.setName(oldAssnsArray[j].getName());
                            }
                        }
                        pasteVect.add(newAnnotation);
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new VWException("vw.api.VWWorkflowDefinitionXMLReadError", " Exception pasting, {0}.", t.getMessage());
        }
        finally {
            if (m != null) {
                this.getWorkflow().deleteMap(m.getName(), false);
            }
        }
        Object[] pasteResult = new IVWPastable[pasteVect.size()];
        pasteVect.copyInto(pasteResult);
        return pasteResult;
    }

    public void deleteStep(int theStepId) throws VWException {
        VWInstructionDefinition[] theInsts;
        int i = this.getIndexOfStepId(theStepId);
        if (this.steps[i] == this.getStartStep()) {
            throw new VWException("vw.api.VWMapDefinitionDeleteLaunchStep", "Unable to delete the first step in a map, step ID {0}.", String.valueOf(theStepId));
        }
        for (int j = 0; j < this.routesHandler.getElementCount(); ++j) {
            if (this.routes[j].getSourceStepId() != theStepId && this.routes[j].getDestinationStepId() != theStepId) continue;
            this.getStep(this.routes[j].getSourceStepId()).deleteRoute(this.routes[j].getRouteId());
            --j;
        }
        for (int k = 0; k < this.annotationsHandler.getElementCount(); ++k) {
            try {
                this.annotations[k].deleteAssociation(theStepId, 1);
                continue;
            }
            catch (VWException e) {
                // empty catch block
            }
        }
        if (this.steps[i] instanceof VWCompoundStepDefinition && (theInsts = ((VWCompoundStepDefinition)this.steps[i]).getInstructions()) != null) {
            int instCount = theInsts.length;
            for (int k = 0; k < instCount; ++k) {
                if (theInsts[k].getAction() == 40 && ((VWReceiveInstruction)theInsts[k]).getPartnerLinkName() != null && ((VWReceiveInstruction)theInsts[k]).getPartnerLinkName().length() > 0 && this.getWorkflow().isExistingPartnerLinkName(((VWReceiveInstruction)theInsts[k]).getPartnerLinkName())) {
                    this.getWorkflow().getPartnerLink(((VWReceiveInstruction)theInsts[k]).getPartnerLinkName()).removeReceiveStepRef((VWReceiveInstruction)theInsts[k]);
                }
                if (theInsts[k].getAction() != 41 || ((VWReplyInstruction)theInsts[k]).getPartnerLinkName() == null || ((VWReplyInstruction)theInsts[k]).getPartnerLinkName().length() <= 0 || !this.getWorkflow().isExistingPartnerLinkName(((VWReplyInstruction)theInsts[k]).getPartnerLinkName())) continue;
                this.getWorkflow().getPartnerLink(((VWReplyInstruction)theInsts[k]).getPartnerLinkName()).removeReplyStepRef((VWReplyInstruction)theInsts[k]);
            }
        }
        this.stepsHandler.deleteElementFromArray(this.steps, i);
    }

    public VWMapNode getStep(int theStepId) throws VWException {
        return this.steps[this.getIndexOfStepId(theStepId)];
    }

    public int getContainingStepId(int theStepId) throws VWException {
        int retId = -2;
        int numSteps = this.stepsHandler.getElementCount();
        block0: for (int i = 0; i < numSteps && retId < 0; ++i) {
            VWInstructionDefinition[] instArray;
            if (this.steps[i].getStepId() == theStepId) {
                retId = -1;
                break;
            }
            if (!(this.steps[i] instanceof VWCompoundStepDefinition) || (instArray = ((VWCompoundStepDefinition)this.steps[i]).getInstructions()) == null) continue;
            for (int j = 0; j < instArray.length; ++j) {
                if (instArray[j].getInstructionId() != theStepId) continue;
                retId = this.steps[i].getStepId();
                continue block0;
            }
        }
        if (retId == -2) {
            throw new VWException("vw.api.VWMapDefinitionStepIdNotFound", " StepId {0} not found.", String.valueOf(theStepId));
        }
        return retId;
    }

    public VWMapNode getStartStep() throws VWException {
        int launchStepIndex = this.stepsHandler.getIndexFromIntFieldValue(this.steps, "stepId", 0);
        if (launchStepIndex != -1) {
            return this.steps[launchStepIndex];
        }
        throw new VWException("vw.api.VWMapDefinitionNoLaunchStepFound", "No start step found.");
    }

    public String getDescription() {
        return this.translateStr(this.description);
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public String getAuthoredName() {
        return this.name;
    }

    public String getName() {
        return this.translateStr(this.name);
    }

    public void setName(String theName) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWWorkFlowMapDefinitionBadName", "Workflow map name cannot be null or empty");
        }
        if (theName.equals(this.name)) {
            return;
        }
        if (this.name != null && this.name.equals("Workflow")) {
            throw new VWException("vw.api.VWWorkFlowMapDefinitionCantRenameMain", "Workflow main map name cannot be changed");
        }
        VWMapDefinition existingMap = null;
        try {
            existingMap = this.getWorkflow().getMap(theName);
        }
        catch (VWException vWException) {
            // empty catch block
        }
        if (existingMap != null) {
            throw new VWException("vw.api.VWMapDefinitionMapNameAlreadyExists", "theName is invalid, (a map named {0} already exists in this workflow definition).", theName);
        }
        this.name = theName;
    }

    public String toString() {
        return this.getName();
    }

    public VWMapNode changeStepType(int theStepId) throws VWException {
        VWInstructionDefinition[] theInsts;
        int i = this.getIndexOfStepId(theStepId);
        if (theStepId == 0 && this.name == "Workflow") {
            throw new VWException("vw.api.VWWorkFlowMapDefinitionCantChangeLaunchStepType", "The launch step''s step type cannot be changed.");
        }
        VWMapNode newStep = null;
        VWMapNode oldStep = this.steps[i];
        if (oldStep instanceof VWStepDefinition) {
            newStep = new VWCompoundStepDefinition(this);
        } else if (oldStep instanceof VWCompoundStepDefinition) {
            newStep = new VWStepDefinition(this);
        }
        if (newStep == null) {
            throw new VWException("vw.api.VWWorkFlowMapDefinitionInvalidOriginalStepType", "The step''s original step type is invalid.");
        }
        newStep.setStepId(oldStep.getStepId());
        newStep.setName(oldStep.getName());
        newStep.setDescription(oldStep.getDescription());
        newStep.setLocation(oldStep.getLocation());
        newStep.setSplitType(oldStep.getSplitType());
        newStep.setJoinType(oldStep.getJoinType());
        newStep.setJoinStepId(oldStep.getJoinStepId());
        newStep.outGoingRoutes = oldStep.outGoingRoutes;
        newStep.outGoingRoutesHandler = oldStep.outGoingRoutesHandler;
        if (oldStep instanceof VWCompoundStepDefinition && (theInsts = ((VWCompoundStepDefinition)oldStep).getInstructions()) != null) {
            int instCount = theInsts.length;
            for (int k = 0; k < instCount; ++k) {
                if (theInsts[k].getAction() == 40 && ((VWReceiveInstruction)theInsts[k]).getPartnerLinkName() != null && ((VWReceiveInstruction)theInsts[k]).getPartnerLinkName().length() > 0) {
                    this.getWorkflow().getPartnerLink(((VWReceiveInstruction)theInsts[k]).getPartnerLinkName()).removeReceiveStepRef((VWReceiveInstruction)theInsts[k]);
                }
                if (theInsts[k].getAction() != 41 || ((VWReplyInstruction)theInsts[k]).getPartnerLinkName() == null || ((VWReplyInstruction)theInsts[k]).getPartnerLinkName().length() <= 0) continue;
                this.getWorkflow().getPartnerLink(((VWReplyInstruction)theInsts[k]).getPartnerLinkName()).removeReplyStepRef((VWReplyInstruction)theInsts[k]);
            }
        }
        this.steps[i] = newStep;
        return newStep;
    }

    public VWMapNode[] getSteps() throws VWException {
        return (VWMapNode[])this.stepsHandler.getElements(this.steps);
    }

    public VWTextAnnotationDefinition[] getTextAnnotations() throws VWException {
        return (VWTextAnnotationDefinition[])this.annotationsHandler.getElements(this.annotations);
    }

    public void deleteTextAnnotation(int theAnnotationId) throws VWException {
        int index = this.annotationsHandler.getIndexFromIntFieldValue(this.annotations, "id", theAnnotationId);
        if (index == -1) {
            throw new VWException("vw.api.VWMapDefinitionAnnotationNotFound", "No annotation found with id equal to {0} in map definition.", String.valueOf(theAnnotationId));
        }
        this.annotationsHandler.deleteElementFromArray(this.annotations, index);
    }

    public VWTextAnnotationDefinition getTextAnnotation(int theAnnotationId) throws VWException {
        int index = this.annotationsHandler.getIndexFromIntFieldValue(this.annotations, "id", theAnnotationId);
        if (index == -1) {
            throw new VWException("vw.api.VWMapDefinitionAnnotationNotFound", "No annotation found with id equal to {0} in map definition.", String.valueOf(theAnnotationId));
        }
        return this.annotations[index];
    }

    public VWTextAnnotationDefinition createTextAnnotation(String theMessage) throws VWException {
        VWTextAnnotationDefinition newAnnotation = new VWTextAnnotationDefinition(this, this.annotationIdGenerator.getNextId(), theMessage, null, null, false);
        this.annotations = (VWTextAnnotationDefinition[])this.annotationsHandler.addElementToArray(this.annotations, newAnnotation);
        return newAnnotation;
    }

    protected VWTextAnnotationDefinition createTextAnnotation(String theMessage, Point location, Dimension dim, boolean minmzd) throws VWException {
        VWTextAnnotationDefinition newAnnotation = new VWTextAnnotationDefinition(this, this.annotationIdGenerator.getNextId(), theMessage, location, dim, minmzd);
        this.annotations = (VWTextAnnotationDefinition[])this.annotationsHandler.addElementToArray(this.annotations, newAnnotation);
        return newAnnotation;
    }

    public void normalize() throws VWException {
        int i = this.getIndexOfStepId(0);
        if (i != 0) {
            VWMapNode oldFirstStep = this.steps[0];
            this.steps[0] = this.steps[i];
            this.steps[i] = oldFirstStep;
        }
    }

    protected static int mapNameToId(String mapName) {
        if (mapName.equals("Workflow")) {
            return -2;
        }
        if (mapName.equals("Terminate")) {
            return -3;
        }
        if (mapName.equals("Malfunction")) {
            return -4;
        }
        if (mapName.equals("QueueAssertionViolation")) {
            return -5;
        }
        if (mapName.equals("Recovery")) {
            return -6;
        }
        if (mapName.equals("Tracker")) {
            return -7;
        }
        return 0;
    }

    public int getMapId() throws VWException {
        return this.mapId;
    }

    protected void setMapId(int newMapId) {
        this.mapId = newMapId;
    }

    protected VWWorkflowDefinition getWorkflow() {
        return this.myWorkflow;
    }

    protected void setWorkflow(VWWorkflowDefinition theWorkflow) {
        this.myWorkflow = theWorkflow;
    }

    protected VWRouteDefinition createRoute(int theSourceId, int theDestinationId) throws VWException {
        if (this.getRouteBetween(theSourceId, theDestinationId) != null) {
            throw new VWException("vw.api.VWMapDefinitionRouteAlreadyExists", "A route from stepId {0} to stepId {1} already exists.", String.valueOf(theSourceId), String.valueOf(theDestinationId));
        }
        VWRouteDefinition newRoute = new VWRouteDefinition(this.getStep(theSourceId), this.routeIdGenerator.getNextId(), theSourceId, theDestinationId);
        this.routes = (VWRouteDefinition[])this.routesHandler.addElementToArray(this.routes, newRoute);
        return newRoute;
    }

    protected VWRouteDefinition createRoute(int theSourceId, int theDestinationId, String theCondition, String theName) throws VWException {
        if (this.getRouteBetween(theSourceId, theDestinationId) != null) {
            throw new VWException("vw.api.VWMapDefinitionRouteAlreadyExists", "A route from stepId {0} to stepId {1} already exists.", String.valueOf(theSourceId), String.valueOf(theDestinationId));
        }
        VWRouteDefinition newRoute = new VWRouteDefinition(this.getStep(theSourceId), this.routeIdGenerator.getNextId(), theSourceId, theDestinationId, theCondition, theName);
        this.routes = (VWRouteDefinition[])this.routesHandler.addElementToArray(this.routes, newRoute);
        return newRoute;
    }

    protected VWRouteDefinition createRoute(int routeId, int theSourceId, int theDestinationId, String theCondition, String theName) throws VWException {
        if (this.getRouteBetween(theSourceId, theDestinationId) != null) {
            throw new VWException("vw.api.VWMapDefinitionRouteAlreadyExists", "A route from stepId {0} to stepId {1} already exists.", String.valueOf(theSourceId), String.valueOf(theDestinationId));
        }
        try {
            this.getRoute(routeId);
            throw new VWException("vw.api.VWMapDefinitionRouteIdAlreadyExists", "A route with route id {0} already exists.", String.valueOf(routeId));
        }
        catch (Exception e) {
            VWRouteDefinition newRoute = new VWRouteDefinition(this.getStep(theSourceId), routeId, theSourceId, theDestinationId, theCondition, theName);
            if (this.routeIdGenerator.getPrevId() <= routeId) {
                this.routeIdGenerator.setNextId(routeId + 1);
            }
            this.routes = (VWRouteDefinition[])this.routesHandler.addElementToArray(this.routes, newRoute);
            return newRoute;
        }
    }

    protected void deleteRoute(int theRouteId) throws VWException {
        int index = this.routesHandler.getIndexFromIntFieldValue(this.routes, "routeId", theRouteId);
        if (index == -1) {
            throw new VWException("vw.api.VWMapDefinitionRouteNotFound", "No route found with id equal to {0} in map definition.", String.valueOf(theRouteId));
        }
        for (int k = 0; k < this.annotationsHandler.getElementCount(); ++k) {
            try {
                this.annotations[k].deleteAssociation(theRouteId, 2);
                continue;
            }
            catch (VWException e) {
                // empty catch block
            }
        }
        this.routesHandler.deleteElementFromArray(this.routes, index);
    }

    protected VWRouteDefinition getRoute(int theRouteId) throws VWException {
        int index = this.routesHandler.getIndexFromIntFieldValue(this.routes, "routeId", theRouteId);
        if (index == -1) {
            throw new VWException("vw.api.VWMapDefinitionRouteNotFound", "No route found with id equal to {0} in map definition.", String.valueOf(theRouteId));
        }
        return this.routes[index];
    }

    protected VWRouteDefinition getRouteBetween(int theSourceId, int theDestinationId) {
        for (int i = 0; i < this.routesHandler.getElementCount(); ++i) {
            if (this.routes[i].getSourceStepId() != theSourceId || this.routes[i].getDestinationStepId() != theDestinationId) continue;
            return this.routes[i];
        }
        return null;
    }

    protected VWRouteDefinition[] getRoutesBySourceStep(int theStepId) throws VWException {
        VWRouteDefinition[] retArray = null;
        VWArrayHandler retArrayHandler = new VWArrayHandler(15, 10);
        for (int i = 0; i < this.routesHandler.getElementCount(); ++i) {
            if (this.routes[i].getSourceStepId() != theStepId) continue;
            retArray = (VWRouteDefinition[])retArrayHandler.addElementToArray(retArray, this.routes[i]);
        }
        return (VWRouteDefinition[])retArrayHandler.getElements(retArray);
    }

    protected VWRouteDefinition[] getRoutesByDestinationStep(int theStepId) throws VWException {
        VWRouteDefinition[] retArray = null;
        VWArrayHandler retArrayHandler = new VWArrayHandler(15, 10);
        for (int i = 0; i < this.routesHandler.getElementCount(); ++i) {
            if (this.routes[i].getDestinationStepId() != theStepId) continue;
            retArray = (VWRouteDefinition[])retArrayHandler.addElementToArray(retArray, this.routes[i]);
        }
        return (VWRouteDefinition[])retArrayHandler.getElements(retArray);
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        VWTextAnnotationDefinition[] a;
        String ATTRIB_INDENT = "\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWMapDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t<Map\n");
        theBuffer.append(ATTRIB_INDENT + "Name=\"" + VWXMLHandler.toXMLString(this.name) + "\"\n");
        if (this.mapId != -1) {
            theBuffer.append(ATTRIB_INDENT + "MapId=\"" + this.mapId + "\"\n");
        }
        theBuffer.append(ATTRIB_INDENT + "MaxStepId=\"" + Integer.toString(this.stepIdGenerator.getPrevId()) + "\"");
        if (this.description != null) {
            theBuffer.append("\n" + ATTRIB_INDENT + "Description=\"" + VWXMLHandler.toXMLString(this.description) + "\"");
        }
        theBuffer.append(" >\n");
        VWMapNode[] s = this.getSteps();
        if (s != null) {
            for (int i = 0; i < s.length; ++i) {
                s[i].toXML(theBuffer);
            }
        }
        if ((a = this.getTextAnnotations()) != null) {
            for (int i = 0; i < a.length; ++i) {
                a[i].toXML(theBuffer);
            }
        }
        theBuffer.append("\t</Map>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        int i;
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWMapDefinitionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        theBuffer.append(indentA + "<Activities>\n");
        VWMapNode[] steps = this.getSteps();
        if (steps != null) {
            for (i = 0; i < steps.length; ++i) {
                steps[i].toXPDL(indentB, theBuffer);
            }
        }
        theBuffer.append(indentA + "</Activities>\n");
        if (this.routes != null && this.routes.length > 0) {
            theBuffer.append(indentA + "<Transitions>\n");
            if (steps != null) {
                for (i = 0; i < steps.length; ++i) {
                    VWRouteDefinition[] outgoingRoutes = steps[i].getNextRoutes();
                    if (outgoingRoutes == null) continue;
                    for (int j = 0; j < outgoingRoutes.length; ++j) {
                        if (outgoingRoutes[j] == null) continue;
                        outgoingRoutes[j].toXPDL(indentB, theBuffer);
                    }
                }
            }
            theBuffer.append(indentA + "</Transitions>\n");
        }
    }

    protected void validate(VWValidationContext validationContext) throws VWException {
        VWValidationError theError;
        VWString theMessage;
        int i = 0;
        int actualStepCount = this.stepsHandler.getElementCount();
        if (actualStepCount <= 0) {
            VWString theMessage2 = new VWString("vw.api.VWMapDefinitionNoSteps", "The map {0} contains no steps.  Maps should always contain at least a launch/start step.", this.getName());
            VWValidationError theError2 = new VWValidationError(6, 1, null, null, theMessage2.toString(), this.getName());
            validationContext.addValidationError(theError2);
            return;
        }
        if (this.steps[0].stepId != 0) {
            theMessage = new VWString("vw.api.VWMapDefinitionFirstStepNotZero", "The first step in the steps array does not have step Id 0.");
            theError = new VWValidationError(1, 1, this.steps[0].getName(), this.getName(), theMessage.toString(), this.getName(), this.steps[0].getStepId());
            validationContext.addValidationError(theError);
        }
        this.seen = null;
        if (this.canReachAllSteps(actualStepCount)) {
            if (validationContext.getShouldFixupSteps()) {
                this.coloringValidateAndFixup(actualStepCount, 0, validationContext);
            }
        } else {
            for (i = 0; i < actualStepCount; ++i) {
                if (this.seen[i] != -1) continue;
                theMessage = new VWString("vw.api.VWMapDefinitionUnReachableStep", "Step cannot be reached from the launch step.");
                theError = new VWValidationError(1, 1, this.steps[i].getName(), this.getName(), theMessage.toString(), this.getName(), this.steps[i].getStepId());
                validationContext.addValidationError(theError);
            }
        }
        for (i = 0; i < actualStepCount; ++i) {
            this.steps[i].validate(validationContext);
        }
        for (i = 0; i < actualStepCount; ++i) {
            VWRouteDefinition[] routes = this.steps[i].getNextRoutes();
            if (routes == null) continue;
            for (int j = 0; j < routes.length; ++j) {
                routes[j].validate(validationContext);
            }
        }
        if (this.annotations != null && this.annotationsHandler != null) {
            for (i = 0; i < this.annotationsHandler.getElementCount(); ++i) {
                this.annotations[i].validate(validationContext);
            }
        }
    }

    private boolean canReachAllSteps(int numberOfSteps) throws VWException {
        int i = 0;
        boolean retval = true;
        this.seen = new int[numberOfSteps];
        for (i = 0; i < numberOfSteps; ++i) {
            this.seen[i] = -1;
        }
        this.visitOrd = 0;
        this.visit(0);
        for (i = 0; i < numberOfSteps; ++i) {
            if (this.seen[i] != -1) continue;
            retval = false;
            break;
        }
        return retval;
    }

    private void visit(int theStepIndex) throws VWException {
        int adjacentStepIndex = -1;
        this.seen[theStepIndex] = ++this.visitOrd;
        VWRouteDefinition[] outRoutes = this.steps[theStepIndex].getNextRoutes();
        if (outRoutes != null) {
            for (int i = 0; i < outRoutes.length; ++i) {
                adjacentStepIndex = this.getIndexOfStepId(outRoutes[i].getDestinationStepId());
                if (this.seen[adjacentStepIndex] != -1) continue;
                this.visit(adjacentStepIndex);
            }
        }
    }

    private void coloringValidateAndFixup(int maxSteps, int theStartStepIndex, VWValidationContext validationContext) throws VWException {
        String m_method = "coloringValidateAndFixup";
        logger.entering(this.m_className, "coloringValidateAndFixup");
        if (logger.isFinest()) {
            logger.finer(this.m_className, "coloringValidateAndFixup", ">>> MAP NAME IS <" + this.getName() + ">");
        }
        int i = 0;
        String[] colorStrings = null;
        int[] previous = new int[maxSteps];
        IntQueue BFSQueue = new IntQueue(maxSteps);
        colorStrings = new String[maxSteps];
        this.visitOrd = 0;
        this.seen = new int[maxSteps];
        for (i = 0; i < maxSteps; ++i) {
            this.seen[i] = -1;
            colorStrings[i] = "";
            previous[i] = 0;
        }
        BFSQueue.put(theStartStepIndex);
        if (logger.isFinest()) {
            logger.finer(this.m_className, "coloringValidateAndFixup", ">>> VISIT AND COLOR all steps.");
        }
        while (!BFSQueue.isEmpty()) {
            VWRouteDefinition[] outRoutes;
            int currentStepIndex = BFSQueue.get();
            this.seen[currentStepIndex] = ++this.visitOrd;
            if (this.steps[currentStepIndex].getSplitType() == 1 || this.steps[currentStepIndex].getJoinType() == 1) {
                if (this.steps[currentStepIndex].getJoinType() == 1 && !colorStrings[previous[currentStepIndex]].equals("")) {
                    String newColor = colorStrings[previous[currentStepIndex]];
                    int idxLastDot = newColor.lastIndexOf(46);
                    colorStrings[currentStepIndex] = newColor = newColor.substring(0, idxLastDot);
                }
                if (this.steps[currentStepIndex].getSplitType() == 1) {
                    colorStrings[currentStepIndex] = this.steps[currentStepIndex].getJoinType() == 1 ? colorStrings[currentStepIndex] + "." + String.valueOf(this.steps[currentStepIndex].getStepId()) : colorStrings[previous[currentStepIndex]] + "." + String.valueOf(this.steps[currentStepIndex].getStepId());
                }
            } else {
                colorStrings[currentStepIndex] = colorStrings[previous[currentStepIndex]];
            }
            if (logger.isFinest()) {
                logger.finer(this.m_className, "coloringValidateAndFixup", "   After Visiting [" + String.valueOf(this.steps[currentStepIndex].getName()) + "], " + "color is  <" + colorStrings[currentStepIndex] + ">");
            }
            if ((outRoutes = this.steps[currentStepIndex].getNextRoutes()) == null) continue;
            for (i = 0; i < outRoutes.length; ++i) {
                int adjacentStepIndex = this.getIndexOfStepId(outRoutes[i].getDestinationStepId());
                if (this.seen[adjacentStepIndex] != -1) continue;
                BFSQueue.put(adjacentStepIndex);
                this.seen[adjacentStepIndex] = -2;
                previous[adjacentStepIndex] = currentStepIndex;
            }
        }
        for (i = 0; i < maxSteps; ++i) {
            this.steps[i].setJoinStepId(-1);
        }
        boolean gotError = false;
        if (logger.isFinest()) {
            logger.finer(this.m_className, "coloringValidateAndFixup", ">>> RE-VISITING STEPS to check nesting and fixup joinStepIds.");
        }
        this.visitOrd = 0;
        if (this.seen == null || this.seen.length != maxSteps) {
            this.seen = new int[maxSteps];
        }
        for (i = 0; i < maxSteps; ++i) {
            this.seen[i] = -1;
        }
        BFSQueue.put(theStartStepIndex);
        while (!BFSQueue.isEmpty()) {
            VWRouteDefinition[] outRoutes;
            VWRouteDefinition[] incomingRoutes;
            int currentStepIndex = BFSQueue.get();
            this.seen[currentStepIndex] = ++this.visitOrd;
            if (logger.isFinest()) {
                logger.finer(this.m_className, "coloringValidateAndFixup", "   Re-Visiting Stepid " + String.valueOf(this.steps[currentStepIndex].getStepId()) + " [" + String.valueOf(this.steps[currentStepIndex].getName()) + "], color is <" + colorStrings[this.getIndexOfStepId(this.steps[currentStepIndex].getStepId())] + ">");
            }
            if ((this.steps[currentStepIndex].getJoinType() == 2 || this.steps[currentStepIndex].getJoinType() == 1) && (incomingRoutes = this.getRoutesByDestinationStep(this.steps[currentStepIndex].getStepId())) != null) {
                for (int j = 0; j < incomingRoutes.length; ++j) {
                    if (colorStrings[this.getIndexOfStepId(incomingRoutes[0].getSourceStepId())].equals(colorStrings[this.getIndexOfStepId(incomingRoutes[j].getSourceStepId())])) continue;
                    gotError = true;
                    VWString theMessage = new VWString("vw.api.VWMapDefinitionMapNotProperlyNested", "Route from {0} to {1} is incorrectly nested.", incomingRoutes[j].getSourceStep().getName(), incomingRoutes[j].getDestinationStep().getName());
                    VWValidationError theError = new VWValidationError(2, 1, incomingRoutes[j].getName(), null, theMessage.toString(), this.getName(), incomingRoutes[j].getSourceStepId(), incomingRoutes[j].getRouteId());
                    validationContext.addValidationError(theError);
                }
                if (!gotError && this.steps[currentStepIndex].getJoinType() == 1 && !colorStrings[this.getIndexOfStepId(incomingRoutes[0].getSourceStepId())].equals("")) {
                    int idxLastDot;
                    String tempColor = colorStrings[this.getIndexOfStepId(incomingRoutes[0].getSourceStepId())];
                    int andSplitStepid = Integer.parseInt(tempColor.substring((idxLastDot = tempColor.lastIndexOf(46)) + 1));
                    VWMapNode andSplitStep = this.getStep(andSplitStepid);
                    if (andSplitStep.getJoinStepId() != -1) {
                        gotError = true;
                        VWString theMessage = new VWString("vw.api.VWMapAndSplitAndJoinMismatch", "Ambiguous split/join pairing, split step {0} can match join step {1} or {2}", andSplitStep.getName(), this.getStep(andSplitStep.getJoinStepId()).getName(), this.steps[currentStepIndex].getName());
                        VWValidationError theError = new VWValidationError(1, 1, andSplitStep.getName(), null, theMessage.toString(), this.getName(), andSplitStep.getStepId());
                        validationContext.addValidationError(theError);
                    } else {
                        andSplitStep.setJoinStepId(this.steps[currentStepIndex].getStepId());
                        if (logger.isFinest()) {
                            logger.finer(this.m_className, "coloringValidateAndFixup", "   SPLIT STEP FIXUP: AND-SPLIT [" + andSplitStep.getName() + "] paired with AND-JOIN [" + this.steps[currentStepIndex].getName() + "]");
                        }
                    }
                }
            }
            if ((outRoutes = this.steps[currentStepIndex].getNextRoutes()) == null) continue;
            for (i = 0; i < outRoutes.length; ++i) {
                int adjacentStepIndex = this.getIndexOfStepId(outRoutes[i].getDestinationStepId());
                if (this.seen[adjacentStepIndex] != -1) continue;
                BFSQueue.put(adjacentStepIndex);
                this.seen[adjacentStepIndex] = -2;
            }
        }
        if (!gotError) {
            if (logger.isFinest()) {
                logger.finest(this.m_className, "coloringValidateAndFixup", ">>> CHECKINIG that all AND-SPLITS have been fixed up.");
            }
            for (i = 0; i < maxSteps; ++i) {
                if (this.steps[i].getSplitType() != 1 || this.steps[i].getJoinStepId() != -1) continue;
                gotError = true;
                VWString theMessage = new VWString("vw.api.VWMapAndSplitNotFixedUp", "No and-join step found for and-split step <{0}>", this.steps[i].getName());
                VWValidationError theError = new VWValidationError(1, 1, this.steps[i].getName(), null, theMessage.toString(), this.getName(), this.steps[i].getStepId());
                validationContext.addValidationError(theError);
            }
        }
        int actualRouteCount = this.routesHandler.getElementCount();
        for (i = 0; i < actualRouteCount; ++i) {
            this.routes[i].setRelease(false);
        }
        if (!gotError) {
            if (logger.isFinest()) {
                logger.finer(this.m_className, "coloringValidateAndFixup", ">>> Begin Route RELEASE processing");
            }
            int BFSvisitOrd = 0;
            int[] BFSseen = null;
            BFSseen = new int[maxSteps];
            for (i = 0; i < maxSteps; ++i) {
                BFSseen[i] = -1;
            }
            BFSQueue.put(theStartStepIndex);
            while (!BFSQueue.isEmpty()) {
                VWRouteDefinition[] outRoutes;
                int currentStepIndex = BFSQueue.get();
                BFSseen[currentStepIndex] = ++BFSvisitOrd;
                if (this.steps[currentStepIndex].getSplitType() == 1 || this.steps[currentStepIndex].getSplitType() == 2) {
                    int targetJoinStepId = -1;
                    if (this.steps[currentStepIndex].getSplitType() == 1) {
                        targetJoinStepId = this.steps[currentStepIndex].getJoinStepId();
                    } else if (!colorStrings[this.getIndexOfStepId(this.steps[currentStepIndex].getStepId())].equals("")) {
                        String tempColor = colorStrings[this.getIndexOfStepId(this.steps[currentStepIndex].getStepId())];
                        int idxLastDot = tempColor.lastIndexOf(46);
                        int andSplitStepId = Integer.parseInt(tempColor.substring(idxLastDot + 1));
                        targetJoinStepId = this.getStep(andSplitStepId).getJoinStepId();
                    }
                    VWRouteDefinition[] outGoingRoutes = this.getRoutesBySourceStep(this.steps[currentStepIndex].getStepId());
                    if (targetJoinStepId != -1 && outGoingRoutes != null) {
                        if (this.seen == null || this.seen.length != maxSteps) {
                            this.seen = new int[maxSteps];
                        }
                        for (int j = 0; j < outGoingRoutes.length; ++j) {
                            for (int k = 0; k < maxSteps; ++k) {
                                this.seen[k] = -1;
                            }
                            this.visitOrd = 0;
                            this.visit(this.getIndexOfStepId(outGoingRoutes[j].getDestinationStepId()));
                            if (this.seen[this.getIndexOfStepId(targetJoinStepId)] != -1) continue;
                            String tempColor = colorStrings[this.getIndexOfStepId(this.steps[currentStepIndex].getStepId())];
                            int idxLastDot = tempColor.lastIndexOf(46);
                            int parentAndSplitId = Integer.parseInt(tempColor.substring(idxLastDot + 1));
                            this.beenThere.clear();
                            if (this.alreadyReleased(parentAndSplitId, this.steps[currentStepIndex].getStepId())) continue;
                            if (logger.isFinest()) {
                                logger.finer(this.m_className, "coloringValidateAndFixup", "   RELEASE: releasing route from [" + this.getStep(outGoingRoutes[j].getSourceStepId()).getName() + "] TO [" + this.getStep(outGoingRoutes[j].getDestinationStepId()).getName() + "]");
                            }
                            outGoingRoutes[j].setRelease(true);
                        }
                    }
                }
                if ((outRoutes = this.steps[currentStepIndex].getNextRoutes()) == null) continue;
                for (i = 0; i < outRoutes.length; ++i) {
                    int adjacentStepIndex = this.getIndexOfStepId(outRoutes[i].getDestinationStepId());
                    if (BFSseen[adjacentStepIndex] != -1) continue;
                    BFSQueue.put(adjacentStepIndex);
                    BFSseen[adjacentStepIndex] = -2;
                }
            }
            if (logger.isFinest()) {
                logger.finer(this.m_className, "coloringValidateAndFixup", ">>> End Route RELEASE processing");
            }
        }
        logger.exiting(this.m_className, "coloringValidateAndFixup");
    }

    private boolean alreadyReleased(int splitParentId, int startId) throws VWException {
        String m_method = "alreadyReleased";
        Object[] params = new Object[]{"splitParent (" + String.valueOf(splitParentId) + ") [" + this.getStep(splitParentId).getName() + "] startid (" + String.valueOf(startId) + ") [" + this.getStep(startId).getName() + "]"};
        logger.entering(this.m_className, "alreadyReleased", params);
        if (splitParentId == startId || startId == 0) {
            if (splitParentId == startId) {
                if (logger.isFinest()) {
                    logger.finest(this.m_className, "alreadyReleased", "startId == splitParentId");
                }
            } else if (startId == 0 && logger.isFinest()) {
                logger.finest(this.m_className, "alreadyReleased", "startId == 0");
            }
            logger.exiting(this.m_className, "alreadyReleased", false);
            return false;
        }
        VWRouteDefinition[] incomingRoutes = this.getRoutesByDestinationStep(startId);
        for (int i = 0; i < incomingRoutes.length; ++i) {
            VWRouteDefinition prevRoute = incomingRoutes[i];
            if (prevRoute.getRelease()) {
                this.beenThere.clear();
                logger.exiting(this.m_className, "alreadyReleased", true);
                return true;
            }
            if (this.beenThere.contains(prevRoute.getSourceStepId())) continue;
            this.beenThere.add(prevRoute.getSourceStepId());
            if (!this.alreadyReleased(splitParentId, prevRoute.getSourceStepId())) continue;
            this.beenThere.clear();
            logger.exiting(this.m_className, "alreadyReleased", true);
            return true;
        }
        return false;
    }

    protected Object clone() {
        try {
            int i;
            VWMapDefinition clonedMap = (VWMapDefinition)super.clone();
            clonedMap.myWorkflow = null;
            if (this.stepIdGenerator != null) {
                clonedMap.stepIdGenerator = (VWIdGenerator)this.stepIdGenerator.clone();
            }
            if (this.steps != null) {
                clonedMap.steps = new VWMapNode[this.steps.length];
                for (i = 0; i < this.steps.length && this.steps[i] != null; ++i) {
                    clonedMap.steps[i] = (VWMapNode)this.steps[i].clone();
                    if (clonedMap.steps[i] == null) continue;
                    clonedMap.steps[i].setMap(clonedMap);
                }
                clonedMap.stepsHandler = (VWArrayHandler)this.stepsHandler.clone();
            }
            if (this.routeIdGenerator != null) {
                clonedMap.routeIdGenerator = (VWIdGenerator)this.routeIdGenerator.clone();
            }
            if (this.routes != null) {
                clonedMap.routes = new VWRouteDefinition[this.routes.length];
                for (i = 0; i < this.routes.length && this.routes[i] != null; ++i) {
                    clonedMap.routes[i] = (VWRouteDefinition)this.routes[i].clone();
                    try {
                        if (clonedMap.routes[i] == null) continue;
                        clonedMap.routes[i].setNode(clonedMap.getStep(clonedMap.routes[i].getSourceStepId()));
                        continue;
                    }
                    catch (VWException e) {
                        return null;
                    }
                }
            }
            clonedMap.routesHandler = (VWArrayHandler)this.routesHandler.clone();
            if (this.annotationIdGenerator != null) {
                clonedMap.annotationIdGenerator = (VWIdGenerator)this.annotationIdGenerator.clone();
            }
            if (this.annotations != null) {
                clonedMap.annotations = new VWTextAnnotationDefinition[this.annotations.length];
                for (i = 0; i < this.annotations.length && this.annotations[i] != null; ++i) {
                    clonedMap.annotations[i] = (VWTextAnnotationDefinition)this.annotations[i].clone();
                    if (clonedMap.annotations[i] == null) continue;
                    clonedMap.annotations[i].setMap(clonedMap);
                }
            }
            clonedMap.annotationsHandler = (VWArrayHandler)this.annotationsHandler.clone();
            return clonedMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected VWSession getSession() throws VWException {
        if (this.myWorkflow != null) {
            return this.myWorkflow.getSession();
        }
        return null;
    }
}

